///////////////
// View Item //
///////////////

#pragma once

#include "Global.h"
#include <iostream.h>

const char ORDER_DECK =     'A';
const char ORDER_SEARCH =   'B';
const char ORDER_CARD =     'C';

void AdjustWindow (epp_Window& window);

class ViewItem : public epp_Frame
{
    public:

        ViewItem ();

        void Open ();
        virtual char Sort () = 0;
        virtual void Hide () = 0;
        virtual void Delete (HWND confirm) = 0;
        virtual void Drop (int) = 0;
        virtual void Rename (HWND) = 0;
        virtual void ModifyCard (int) = 0;
        virtual void DeleteCard (int) = 0;

        virtual void Load (istream&) = 0;
        virtual void LoadData (istream&) = 0;
        virtual void Save (ostream&) = 0;
        virtual void SaveData (ostream&) = 0;

        virtual HMENU GetMenu () = 0;
        virtual int GetCard () = 0;

        void StartDrag (HWND);

        operator const RECT& ();

    protected:

        RECT _Rect;

    private:

        void SetRect ();

        void OnClose ();
        int OnCreate (CREATESTRUCT *);
        void OnLButtonUp (int, int, int);
        void OnMove (int, int);
        void OnSize (int, int, int);
        LRESULT OnItemClose (WPARAM, LPARAM);

        BOOL Dragging;
        int DragCard;
        HWND Disabled;
        HCURSOR OldCursor;

    DECLARE_HANDLER
};

inline ViewItem::operator const RECT& ()
    { return _Rect; }